(function($) { 'use strict';
	// Calculate clients viewport
	const w = window, 
	d = document,
	e = d.documentElement,
	g = d.getElementsByTagName('body')[0];

	let x = w.innerWidth || e.clientWidth || g.clientWidth, // Viewport Width
	y = w.innerHeight || e.clientHeight || g.clientHeight; // Viewport Height

	// Global vars
	const htmlEl = document.documentElement;
	const body = document.body;
	let htmlOffsetTop = parseInt(window.getComputedStyle(htmlEl).marginTop);

	// Custom input number field
	function customNumInput(){

		var inputNum = $('input.input-text.qty');

		if(inputNum.length){
			inputNum.each(function(){
				var thisInput = $(this);
				var thisInputVal = parseInt(thisInput.val());
				var minVal = parseInt(thisInput.attr('min'));
				var maxVal = parseInt(thisInput.attr('max'));
				var value = isNaN(thisInputVal) ? 0 : parseInt(thisInputVal);

				if (isNaN(minVal)){
					minVal = 0;
				}

				if (isNaN(maxVal)){
					maxVal = Number.MAX_VALUE;
				}

				if(!thisInput.siblings('.up').length){
					thisInput.parent('.quantity').prepend('<button class="down">－</button>').append('<button class="up">＋</button>');
				}
				var adjustVal = thisInput.siblings('button');

				adjustVal.on('click', function(e){
					e.preventDefault();
					var $this = $(this);


					if ($this.is('.down') && (value > minVal)){
						value--;
					}
					else if ($this.is('.up') && (value < maxVal)){
						value++;
					}
					thisInput.val(value);

					$(this).parents('form').find('input[name=update_cart], button[name=update_cart]').prop("disabled", false);
				});
			});
		}
	}

	$(document.body).on('updated_cart_totals', function() {
		customNumInput();
	});

	$(function(){
		// On scroll
		const fnOnScroll = function(){
			//alert("estoy escroleando");
			const animateBlock = $('.h-animate--from-top, .h-animate--from-left, .h-animate--from-right, .h-animate--from-bottom, .js-reveal--from-top, .js-reveal--from-bottom, .h-reveal--images--from-bottom, .wp-block-separator, .products > .product, .wc-block-grid__products .wc-block-grid__product');

			animateBlock.removeClass('is-loading');

			animateBlock.each(function(){
				const $this = $(this);
				const animateBlockOffsetTop = $this.offset().top;
				let activationOffset;

				// Determinate distance to initiate animation relative to viewport height - add date-offset attribute to animating element. Default is date-offset="1.2"
				if($this.data('offset'))
					activationOffset = $this.data('offset');
				else if($this.hasClass('h-reveal--images--from-bottom'))
					activationOffset = 1.8;
				else if($this.hasClass('product'))
					activationOffset = 1.05;
				else
					activationOffset = 1.2;

				if((window.pageYOffset > animateBlockOffsetTop - y / activationOffset)){
					$this.addClass('scrolled-to');
				}
			});
		};

		fnOnScroll();

		window.onscroll = function() {
			setTimeout(function(){
				fnOnScroll();
			},300);
		};

		// Custom input number field
		customNumInput();

		// Add Show class to body
		body.classList.add('show');

	}); // End Document Ready


})(jQuery);